--[[
  Some utilities for working with KN5 files. Can be used from all types of scripts, including background workers.
]]
---@diagnostic disable

-- Actual library:
local kn5Utils = {}

---Collect list of textures in KN5 file.
---@param kn5Filename string
---@param filter string? @Texture names filter. Default value: `'?'`.
---@return string[]? @Returns `nil` if there is no such file, no access to it or the file is damaged.
function kn5Utils.collectKN5TextureNames(kn5Filename, filter)
  return __util.native('kn5_texture_names', kn5Filename, filter)
end

---Collect list of material properties in KN5 file in a form of shader replacements config.
---@param kn5Filename string
---@param filter string? @Material names filter. Default value: `'?'`.
---@return string[]? @Returns `nil` if there is no such file, no access to it or the file is damaged.
function kn5Utils.collectKN5MaterialProperties(kn5Filename, filter)
  return __util.native('kn5_material_props', kn5Filename, filter)
end

return kn5Utils
