-- Define the allowed IP address
local ALLOWED_IP = "2.57.19.234"

-- Function to check if the server IP is allowed
local function isServerAllowed()
    -- Hypothetical function to get the server IP (not natively supported in AC Lua API)
    local serverIP = ac.getServerIP() or "UNKNOWN"
    return serverIP == ALLOWED_IP
end

-- Initialize variables
local counter = 0

-- Main update function
function script.update(dt)
    -- Skip if the car is AI-controlled
    if car.isAIControlled then
        return
    end

    -- Access car physics data
    local data = ac.accessCarPhysics()

    -- Check if the server IP is allowed
    if not isServerAllowed() then
        -- Lock the car by setting RPM to 0
        data.rpm = 0
        -- Display a message in-game
        ac.message("This car is only drivable on SlimRacing Servers.", 10)
        return
    end

    -- If the server IP is allowed, allow the car to function normally
    if not car.extraA then
        data.rpm = 0
        counter = 0
    elseif counter < 1.5 then
        if counter < 1.5 then
            data.rpm = 0
        else
            data.gas = 0.6
        end
        counter = counter + dt
    end
end