local speed_digit_prefix = 'GAUGE_SIRIUS_SPEED_DIGITS_'
local speed
local speed_display = ac.findMeshes('GAUGE_SIRIUS_SPEED_GLASS_SUB0')

local turbo_digit_prefix = 'GAUGE_SIRIUS_TURBO_DIGITS_'
local turboBoost,count
local turbo_display = ac.findMeshes('GAUGE_SIRIUS_TURBO_GLASS')

function script.update(dt)

    -- speed meter
    speed = ac.getCar().speedKmh

    speed_display:setMaterialTexture('txDiffuse',{
        textureSize = vec2(512,512),
        background = rgbm(0,0,0,0),
        callback = function(dt)
            display.text {
                text = string.format("%3d",speed),
                pos = vec2(80,180),
                letter = vec2(120,120),
                font = "digit_sirius",
                color = rgbm(10,6,0,1),
                width = 8,
                alignment = 1,
                spacing = 0
            }
        end
    })
        
    for i = 0,29 do
        if speed > i * 10 + 10 then
            ac.findMeshes(speed_digit_prefix .. i):setVisible(true)
        else
            ac.findMeshes(speed_digit_prefix .. i):setVisible(false)
        end
    end 

    -- turbo meter
    turboBoost = math.floor(ac.getCar().turboBoost*100)/100

    turbo_display:setMaterialTexture('txDiffuse',{
        textureSize = vec2(512,512),
        background = rgbm(0,0,0,0),
        callback = function(dt)
            display.text {
                text = string.format("%03d",turboBoost*100),
                pos = vec2(110,195),
                letter = vec2(100,100),
                font = "digit_sirius",
                color = rgbm(10,6,0,1),
                width = 8,
                alignment = 0.5,
                spacing = 0
            }
        end
    })

    count = -1
    for i = 0, 29 do
        if turboBoost >count then
            ac.findMeshes(turbo_digit_prefix .. i):setVisible(true)
        else
            ac.findMeshes(turbo_digit_prefix .. i):setVisible(false)
        end
        if count < 0 then
            count = count + 0.2
        else
            count = count + 0.1
        end
    end

end
