-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['lift'] = -1
  electrics.values['lift_input'] = -1
end

local function updateGFX(dt) -- ms
  electrics.values['lift'] = math.min(1, math.max(-1.0, (electrics.values['lift'] + electrics.values['lift_input'] * dt * 0.25)))
end

local function setLift(value)
	electrics.values['lift_input'] = value 
	if value < 0 then
	guihooks.message("Dropping Axle")
	elseif value > 0 then
	guihooks.message("Lifting Axle")
	end
end

local function toggleLift()
  if electrics.values['lift_input'] < 0 then
	electrics.values['lift_input'] = 1
	guihooks.message("Lifting Axle")
  else
	electrics.values['lift_input'] = -1
	guihooks.message("Dropping Axle")
  end
end


-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.toggleLift = toggleLift
M.setLift = setLift

return M
