-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}

local function onReset()
  electrics.values['auxSteer'] = 0
  electrics.values['rearSteer'] = 1
end

local function updateGFX(dt) -- ms
	if electrics.values['rearSteer'] == 1 then
		electrics.values['auxSteer'] = electrics.values['steering_input']
	else
		electrics.values['auxSteer'] = 0
	end
end

local function setRearSteer(value)
	electrics.values['rearSteer'] = value 
	if value <= 0 then
	guihooks.message("Rear Steer disabled")
	elseif value > 0 then
	guihooks.message("Rear Steer enabled")
	end
end

local function toggleRearSteer()
  if electrics.values['rearSteer'] <= 0 then
	electrics.values['rearSteer'] = 1
	guihooks.message("Rear Steer enabled")
  else
	electrics.values['rearSteer'] = 0
	guihooks.message("Rear Steer disabled")
  end
end

-- public interface
M.onInit    = onReset
M.onReset   = onReset
M.updateGFX = updateGFX
M.toggleRearSteer = toggleRearSteer
M.setRearSteer = setRearSteer

return M
