-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = "engine"

local engine = nil
local throttleSet = nil

local function updateGFX(dt)

end

local function setEngineIgnition(enabled)
  if engine then
    engine:setIgnition(enabled)
	guihooks.message("Generator Off")
  end
end

local function setStarter(enabled)
  if engine and engine.starterMaxAV then
    if enabled and (engine.outputAV1 < engine.starterMaxAV * 0.8) then
      engine:activateStarter()
	  guihooks.message("Starting Generator")
    else
      engine:deactivateStarter()
    end
  end
end

local function toggleEngineIgnition(enabled)
  if engine and engine.starterMaxAV then
    if enabled and (engine.outputAV1 < engine.starterMaxAV * 0.8) then
      engine:activateStarter()
	  guihooks.message("Starting Generator")
    elseif enabled and (engine.outputAV1 > engine.maxIdleAV * 2) then
		engine:setIgnition(enabled)
		guihooks.message("Generator Off")
	else
	
      engine:deactivateStarter()
    end
  end
end


local function serialize()

end

local function deserialize(data)

end

local function init(jbeamData)
  engine = powertrain.getDevice(jbeamData.engineName)
  throttleSet = jbeamData.throttleSet
  
  electrics.values['auxGenTrottle'] = throttleSet
  electrics.values['eGenTrottle'] = 0
  electrics.values['eGenRegen'] = 1
end

local function initLastStage(jbeamData)

end

M.init = init
M.initLastStage = initLastStage
M.updateGFX = updateGFX
M.setEngineIgnition = setEngineIgnition
M.toggleEngineIgnition = toggleEngineIgnition
M.setStarter = setStarter
M.serialize = serialize
M.deserialize = deserialize

return M
