-- This Source Code Form is subject to the terms of the bCDDL, v. 1.1.
-- If a copy of the bCDDL was not distributed with this
-- file, You can obtain one at http://beamng.com/bCDDL-1.1.txt

local M = {}
M.type = "auxiliary"
M.relevantDevice = "transfercase"

local max = math.max
local min = math.min
local abs = math.abs

local newDesiredGearIndex = 0
local previousGearIndex = 0
local gearbox = nil
local engine = nil
local hasBuiltPie = false

local function updateGFX(dt)

end



local function shiftToGearIndex(index)
  if gearBox then
   gearBox.setGearIndex(gearBox, index)
   
  end

end

local function shiftUpOnDown()
  --print("shift up - onDown")
  local gearIndex = gearBox.gearIndex + 1
  gearIndex = min(max(gearIndex, gearBox.minGearIndex), gearBox.maxGearIndex)
  
  gearBox.setGearIndex(gearBox, gearIndex)

end


local function shiftDownOnDown()
  --print("shift down - onDown")
  local gearIndex = gearBox.gearIndex - 1
  gearIndex = min(max(gearIndex, gearBox.minGearIndex), gearBox.maxGearIndex)
  
  gearBox.setGearIndex(gearBox, gearIndex)

  end

local function serialize()

end

local function deserialize(data)

end

local function init(jbeamData)
  gearBox = powertrain.getDevice(jbeamData.gearBoxName)
  
end

local function initLastStage(jbeamData)

end

M.init = init
M.initLastStage = initLastStage
M.updateGFX = updateGFX
M.shiftToGearIndex = shiftToGearIndex
M.shiftUpOnDown = shiftUpOnDown
M.shiftDownOnDown = shiftDownOnDown
M.serialize = serialize
M.deserialize = deserialize


return M
